/////////////////////////////////////////////////////////////////////////////
// LogoxAppDlg.cpp : Implementierungsdatei
// (C) Copyright G DATA Software AG 1992-2001

#include "stdafx.h"
#include "LogoxApp.h"
#include "LogoxAppDlg.h"
#include "RecordDlg.h"
#include "FontDlg.h"

/////////////////////////////////////////////////////////////////////////////

#if defined(SETGDATALICENCE)
#include "licence.h"
#else
#define DoLicence() ;
#endif

/////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

class CAboutDlg : public CDialog
{
	public:
	CAboutDlg();

	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

	protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CLogoxAppDlg 
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

CLogoxAppDlg::CLogoxAppDlg(CWnd* pParent) : CDialog(CLogoxAppDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLogoxAppDlg)
	m_bMouth = TRUE;
	m_bChunk = TRUE;
	m_bAction = TRUE;
	m_bParam = TRUE;
	m_bSentence = TRUE;
	m_bViseme = TRUE;
	m_bWord = TRUE;
	m_bLineMark = FALSE;
	m_bMark = TRUE;
	m_szText = _T("");
	m_dwActionID = 0;
	m_iIntonation = 0;
	m_iPitch = 0;
	m_iRoughness = 0;
	m_iSpeed = 0;
	m_iVolume = 0;
	m_szIntonation = _T("");
	m_szPitch = _T("");
	m_szRoughness = _T("");
	m_szSpeed = _T("");
	m_szVolume = _T("");
	m_iFont = -1;
	m_bNotifyGlobal = FALSE;
	//}}AFX_DATA_INIT

	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CLogoxAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CLogoxAppDlg)
	DDX_Control(pDX, IDC_NOTIFY, m_ctrlNotify);
	DDX_Control(pDX, IDC_FONT, m_ctrlFont);
	DDX_Control(pDX, IDC_TEXT, m_ctrlText);
	DDX_Control(pDX, IDC_SLIDE_ROUGHNESS, m_ctrlSlideRoughness);
	DDX_Control(pDX, IDC_SLIDE_INTONATION, m_ctrlSlideIntonation);
	DDX_Control(pDX, IDC_SLIDE_SPEED, m_ctrlSlideSpeed);
	DDX_Control(pDX, IDC_SLIDE_PITCH, m_ctrlSlidePitch);
	DDX_Control(pDX, IDC_SLIDE_VOLUME, m_ctrlSlideVolume);
	DDX_Slider(pDX, IDC_SLIDE_INTONATION, m_iIntonation);
	DDX_Slider(pDX, IDC_SLIDE_PITCH, m_iPitch);
	DDX_Slider(pDX, IDC_SLIDE_ROUGHNESS, m_iRoughness);
	DDX_Slider(pDX, IDC_SLIDE_SPEED, m_iSpeed);
	DDX_Slider(pDX, IDC_SLIDE_VOLUME, m_iVolume);
	DDX_Check(pDX, IDC_MOUTH, m_bMouth);
	DDX_Check(pDX, IDC_CHUNK, m_bChunk);
	DDX_Check(pDX, IDC_ACTION, m_bAction);
	DDX_Check(pDX, IDC_PARAM, m_bParam);
	DDX_Check(pDX, IDC_SENTENCE, m_bSentence);
	DDX_Check(pDX, IDC_VISEME, m_bViseme);
	DDX_Check(pDX, IDC_WORD, m_bWord);
	DDX_Check(pDX, IDC_LINE_MARK, m_bLineMark);
	DDX_Check(pDX, IDC_MARK, m_bMark);
	DDX_Check(pDX, IDC_NOTIFY_GLOBAL, m_bNotifyGlobal);
	DDX_Text(pDX, IDC_TEXT, m_szText);
	DDX_Text(pDX, IDC_ACTIONID, m_dwActionID);
	DDX_Text(pDX, IDC_TEXT_INTONATION, m_szIntonation);
	DDX_Text(pDX, IDC_TEXT_PITCH, m_szPitch);
	DDX_Text(pDX, IDC_TEXT_ROUGHNESS, m_szRoughness);
	DDX_Text(pDX, IDC_TEXT_SPEED, m_szSpeed);
	DDX_Text(pDX, IDC_TEXT_VOLUME, m_szVolume);
	DDX_CBIndex(pDX, IDC_FONT, m_iFont);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLogoxAppDlg, CDialog)
	//{{AFX_MSG_MAP(CLogoxAppDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_SPEAK, OnSpeak)
	ON_BN_CLICKED(IDC_PAUSE, OnPause)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_BN_CLICKED(IDC_RECORD, OnRecord)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_ACTION, OnUpdateNow)
	ON_CBN_SELENDOK(IDC_FONT, OnSelendokFont)
	ON_BN_CLICKED(IDC_NOTIFY_GLOBAL, OnNotifyGlobal)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_RESET, OnReset)
	ON_BN_CLICKED(IDC_CHUNK, OnUpdateNow)
	ON_BN_CLICKED(IDC_SENTENCE, OnUpdateNow)
	ON_BN_CLICKED(IDC_WORD, OnUpdateNow)
	ON_BN_CLICKED(IDC_MOUTH, OnUpdateNow)
	ON_BN_CLICKED(IDC_PARAM, OnUpdateNow)
	ON_BN_CLICKED(IDC_MARK, OnUpdateNow)
	ON_BN_CLICKED(IDC_VISEME, OnUpdateNow)
	ON_BN_CLICKED(IDC_LINE_MARK, OnUpdateNow)
	ON_BN_CLICKED(IDC_SELECT_FONT, OnSelectFont)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_NOTIFY_ACTION,OnNotifyAction)
	ON_MESSAGE(WM_NOTIFY_MARK,OnNotifyMark)
	ON_MESSAGE(WM_NOTIFY_CHUNK,OnNotifyChunk)
	ON_MESSAGE(WM_NOTIFY_PARAM,OnNotifyParam)
	ON_MESSAGE(WM_NOTIFY_SENTENCE,OnNotifySentence)
	ON_MESSAGE(WM_NOTIFY_WORD,OnNotifyWord)
	ON_MESSAGE(WM_NOTIFY_MOUTH,OnNotifyMouth)
	ON_MESSAGE(WM_NOTIFY_VISEME,OnNotifyViseme)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Parameter von Logox erfragen
void CLogoxAppDlg::GetParamFromLogox()
{
	m_iVolume = LogoxGetLocalVolume()/10;
	m_iPitch = LogoxGetLocalPitch()/100;
	m_iSpeed = LogoxGetLocalSpeed()/10;
	m_iIntonation = LogoxGetLocalIntonation()/10;
	m_iRoughness = LogoxGetLocalRoughness()/10;
}

/////////////////////////////////////////////////////////////////////////////
// Logox Parameter setzen
void CLogoxAppDlg::SetParamToLogox()
{
	LogoxSetLocalVolume(m_iVolume*10);
	LogoxSetLocalPitch(m_iPitch*100);
	LogoxSetLocalSpeed(m_iSpeed*10);
	LogoxSetLocalIntonation(m_iIntonation*10);
	LogoxSetLocalRoughness(m_iRoughness*10);
}

/////////////////////////////////////////////////////////////////////////////
// Werte-Strings der Parameter bilden
void CLogoxAppDlg::RefreshStatics()
{
	char szFormated[50];

	sprintf(szFormated,"&Volume: %+d dB",m_iVolume);
	m_szVolume=szFormated;

	sprintf(szFormated,"&Pitch: %+d Hz",m_iPitch*10);
	m_szPitch=szFormated;

	sprintf(szFormated,"&Speed: %d%%",m_iSpeed*10);
	m_szSpeed=szFormated;

	sprintf(szFormated,"&Intonation: %d%%",m_iIntonation*10);
	m_szIntonation=szFormated;

	sprintf(szFormated,"&Roughness: %d Hz",m_iRoughness);
	m_szRoughness=szFormated;
}

/////////////////////////////////////////////////////////////////////////////
// Liste mit Fonts zusammenstellen
void CLogoxAppDlg::RefreshFonts()
{
	CString str;
	unsigned long nFonts = LogoxGetNumberOfFonts();
	unsigned long nFont = LogoxGetLocalFont();
	unsigned long n;
	int i;

	m_ctrlFont.ResetContent();

	UINT idx=m_ctrlFont.AddString("<Standard Sprecher>");
	m_ctrlFont.SetItemData(idx,0xFFFFFFFF);

	for(n=0;n<nFonts;n++)
	{
		char Name[64];
		LogoxGetFontName(n,Name,sizeof(Name));
		idx=m_ctrlFont.AddString(Name);
		m_ctrlFont.SetItemData(idx,n);
	}

	for(i=0;i<m_ctrlFont.GetCount();i++)
	{
		if(m_ctrlFont.GetItemData(i)==nFont)
		{
			m_iFont=i;
			break;
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// WM_INITDIALOG
BOOL CLogoxAppDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Hinzufgen des Menbefehls "Info..." zum Systemmen.
	// IDM_ABOUTBOX muss sich im Bereich der Systembefehle befinden.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{	
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
	// wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	// Defaulttext setzen
	m_szText=_T("Guten Tag, dieses ist ein einfacher Testtext!");

	// Slider "eichen"
	m_ctrlSlideVolume.SetRange(-98,12,TRUE);
	m_ctrlSlidePitch.SetRange(-10,10,TRUE);
	m_ctrlSlideSpeed.SetRange(1,30,TRUE);
	m_ctrlSlideIntonation.SetRange(0,30,TRUE);
	m_ctrlSlideRoughness.SetRange(0,100,TRUE);

	// Lizensierung vornehmen
	DoLicence();

	// Logox initialisieren
	LogoxInitialize();
	LogoxLoadSettings(_T("Logox4 Test Application"));

	// Parameter von Logox holen
	GetParamFromLogox();

	// Fontliste updaten
	RefreshFonts();

	// Werte-Strings updaten
	RefreshStatics();

	// Notification registrieren
	LogoxNotifyAction(m_hWnd,WM_NOTIFY_ACTION,0);
	LogoxNotifyChunk(m_hWnd,WM_NOTIFY_CHUNK,0);
	LogoxNotifyParam(m_hWnd,WM_NOTIFY_PARAM,0);
	LogoxNotifyMark(m_hWnd,WM_NOTIFY_MARK,0);
	LogoxNotifySentence(m_hWnd,WM_NOTIFY_SENTENCE,0);
	LogoxNotifyWord(m_hWnd,WM_NOTIFY_WORD,0);
	LogoxNotifyMouth(m_hWnd,WM_NOTIFY_MOUTH,0);
	LogoxNotifyViseme(m_hWnd,WM_NOTIFY_VISEME,0);

	// update dialog
	UpdateData(FALSE);

	return TRUE; 
}

/////////////////////////////////////////////////////////////////////////////
// WM_SYSCOMMAND
void CLogoxAppDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	// About anzeigen?
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

/////////////////////////////////////////////////////////////////////////////
// WM_PAINT
void CLogoxAppDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this);
		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

/////////////////////////////////////////////////////////////////////////////
// WM_QUERYDRAGICON
HCURSOR CLogoxAppDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/////////////////////////////////////////////////////////////////////////////
// WM_HSCROLL
void CLogoxAppDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	UpdateData(TRUE);
	RefreshStatics();
	SetParamToLogox();
	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY::ON_CBN_SELENDOK::IDC_FONT
void CLogoxAppDlg::OnSelendokFont() 
{
	UpdateData(TRUE);
	unsigned long nFont = m_ctrlFont.GetItemData(m_iFont);
	LogoxSetLocalFont(nFont);
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDOK
void CLogoxAppDlg::OnOK() 
{
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDCANCEL
void CLogoxAppDlg::OnCancel() 
{
	LogoxSaveSettings(_T("Logox4 Test Application"));
	CDialog::OnCancel();
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDC_SPEAK
void CLogoxAppDlg::OnSpeak() 
{
	UpdateData(TRUE);
	LogoxSpeak((LPCTSTR)m_szText,m_dwActionID);
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDC_PAUSE
void CLogoxAppDlg::OnPause() 
{
	if (LogoxIsPaused())
	{
		LogoxResume();
	}
	else
	{
		LogoxPause();
	}
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDC_STOP
void CLogoxAppDlg::OnStop() 
{
	LogoxStop();
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDC_RECORD
void CLogoxAppDlg::OnRecord() 
{
	UpdateData(TRUE);

	CRecordFileDlg dlg;

	if(dlg.DoModal()==IDOK)
	{
		LogoxSetAudioFormat(dlg.GetFormat());
		LogoxRecord(dlg.GetPathName(),(LPCTSTR)m_szText,m_dwActionID);
	}
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDC_RESET
void CLogoxAppDlg::OnReset() 
{
	UpdateData(TRUE);
	LogoxResetLocal();
	GetParamFromLogox();
	RefreshStatics();
	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDC_CLEAR
void CLogoxAppDlg::OnClear() 
{
	m_ctrlNotify.ResetContent();
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::<checkboxes>
void CLogoxAppDlg::OnUpdateNow() 
{
	UpdateData(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDC_SELECTFONT
void CLogoxAppDlg::OnSelectFont() 
{
	CFontDlg dlg(this);
	
	if(dlg.DoModal()==IDOK)
	{
		UpdateData(TRUE);
		UINT nFont = dlg.GetFontID();

		LogoxSetLocalFont(nFont);

		for(int i=0;i<m_ctrlFont.GetCount();i++)
		{
			if(m_ctrlFont.GetItemData(i)==nFont)
			{
				m_iFont=i;
				break;
			}
		}

		UpdateData(FALSE);
	}	
}


/////////////////////////////////////////////////////////////////////////////
// WM_COMMAND::IDC_NOTIFY_GLOBAL
void CLogoxAppDlg::OnNotifyGlobal() 
{
	UpdateData(TRUE);
	if (m_bNotifyGlobal)
	{
		LogoxNotifyModeGlobal();
	}
	else
	{
		LogoxNotifyModeLocal();
	}
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY_ACTION (WM_USER)
LRESULT CLogoxAppDlg::OnNotifyAction(WPARAM wParam, LPARAM lParam)
{
	if (m_bAction)
	{
		CString str;

		str.Format("Action %d/%d",wParam,lParam);
		m_ctrlNotify.AddString(str);
		m_ctrlNotify.SetTopIndex(m_ctrlNotify.GetCount()-1);
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY_CHUNK (WM_USER)
LRESULT CLogoxAppDlg::OnNotifyChunk(WPARAM wParam, LPARAM lParam)
{
	if (m_bChunk)
	{
		CString str;

		str.Format("Chunk %d/%d",wParam,lParam);
		m_ctrlNotify.AddString(str);
		m_ctrlNotify.SetTopIndex(m_ctrlNotify.GetCount()-1);
	}
	//RefreshFonts();

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY_PARAM (WM_USER)
LRESULT CLogoxAppDlg::OnNotifyParam(WPARAM wParam, LPARAM lParam)
{
	if (m_bChunk)
	{
		CString str;

		str.Format("Param %d/%d",wParam,lParam);
		m_ctrlNotify.AddString(str);
		m_ctrlNotify.SetTopIndex(m_ctrlNotify.GetCount()-1);
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY_SENTENCE (WM_USER)
LRESULT CLogoxAppDlg::OnNotifySentence(WPARAM wParam, LPARAM lParam)
{
	if (m_bSentence)
	{
		CString str;

		str.Format("Sentence %d/%d",wParam,lParam);
		m_ctrlNotify.AddString(str);
		m_ctrlNotify.SetTopIndex(m_ctrlNotify.GetCount()-1);
		if (m_bLineMark)
		{
			m_ctrlText.SetSel(wParam,wParam+lParam,FALSE);
		}
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY_WORD (WM_USER)
LRESULT CLogoxAppDlg::OnNotifyWord(WPARAM wParam, LPARAM lParam)
{
	if (m_bWord)
	{
		CString str;

		str.Format("Word %d/%d",wParam,lParam);
		m_ctrlNotify.AddString(str);
		m_ctrlNotify.SetTopIndex(m_ctrlNotify.GetCount()-1);
		if (!m_bLineMark)
		{
			m_ctrlText.SetSel(wParam,wParam+lParam,FALSE);
		}
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY_MOUTH (WM_USER)
LRESULT CLogoxAppDlg::OnNotifyMouth(WPARAM wParam, LPARAM lParam)
{
	if (m_bMouth)
	{
		CString str;

		str.Format("Mouth %08X/%08X",wParam,lParam);
		m_ctrlNotify.AddString(str);
		m_ctrlNotify.SetTopIndex(m_ctrlNotify.GetCount()-1);
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY_MARK (WM_USER)
LRESULT CLogoxAppDlg::OnNotifyMark(WPARAM wParam, LPARAM lParam)
{
	if (m_bMark)
	{
		CString str;

		str.Format("Mark %d/%d",wParam,lParam);
		m_ctrlNotify.AddString(str);
		m_ctrlNotify.SetTopIndex(m_ctrlNotify.GetCount()-1);
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// WM_NOTIFY_VISEME (WM_USER)
LRESULT CLogoxAppDlg::OnNotifyViseme(WPARAM wParam, LPARAM lParam)
{
	if (m_bViseme)
	{
		CString str;

		str.Format("Viseme %d/%d",wParam,lParam);
		m_ctrlNotify.AddString(str);
		m_ctrlNotify.SetTopIndex(m_ctrlNotify.GetCount()-1);
	}
	return 0;
}






